/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

float random( vec2 p )
{
   float q = p.x * 269.5 + p.y * 183.3;
   return fract( sin( q ) * 43758.5453 );
}

float noise( vec2 point )
{
   vec2 p = floor( point );
   vec2 f = fract( point );
   return mix(
      mix( random( p + vec2( 0.0, 0.0 ) ), random( p + vec2( 1.0, 0.0 ) ), f.x ),
      mix( random( p + vec2( 0.0, 1.0 ) ), random( p + vec2( 1.0, 1.0 ) ), f.x ),
      f.y
   );
}

float fractal( vec2 point )
{
    float sum = 0.0;
    float scale = 0.5;
    for ( int i = 0; i < 5; i++ )
   {
      sum += noise( point ) * scale;
      point *= 2.0;
      scale /= 2.0;
   }

   return sum;
}

void main( void )
{
   vec2 point = gl_FragCoord.xy / iResolution.x;
   point.x += iGlobalTime * 0.1;

   point.y /= 5.0;
   point.x /= 50.0;
   float value    = fractal( point * 20.0 );

   value = value * 40.0;
   value = fract(value);

   vec3 darkBrown = vec3( 0.5, 0.1, 0.1 );
   vec3 lightBrown = vec3( 0.75, 0.4, 0.2 );
   vec3 color = mix( darkBrown, lightBrown, value );

   gl_FragColor = vec4 ( color, 1.0 );
}
